<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
	$count = 0;
?>
				<h1>Application List</h1>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					<script>
						$(function() {
							$("#tabs").tabs();
							$('[id^=public-modal]').dialog({ autoOpen: false })
							$('[id^=public-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('public-link','');
								$('[id^=public-modal]').dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id=public-modal'+id+']').dialog('open');
							});
							$('[id^=private-modal]').dialog({ autoOpen: false })
							$('[id^=private-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('private-link','');
								$( "[id^=private-modal]" ).dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id^=private-modal'+id+']').dialog('open');
							});
						});
					</script>
					
					<?PHP
						echo form_open('/applications/list',array('id'=>'app_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'active_page_on_bar' => '',
							'active_page_select' => '',
							'active_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'pending_page_on_bar' => '',
							'pending_page_select' => '',
							'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'denied_page_on_bar' => '',
							'denied_page_select' => '',
							'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">
						<ul>
							<li><a id="active_link" href="#active">Active</a></li>
							<li><a id="pending_link" href="#pending">Pending Approval</a></li>
							<li><a id="denied_link" href="#denied">Denied</a></li>
						</ul>
						<div id="active">
							<p>This table lists the current applications that are authorized to utilize the Direct API 
							web services.</p>
							<?php if (sizeof($active_list) == 0) { ?>
								<div class="message">You currently have no active applications.</div>
							<?php }else{ ?>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
								<table class="display">
									<tr>
										<th width="25%">Name</th>
										<th width="25%">POC</th>
										<th width="25%">Application Keys</th>
										<th width="25%" class="displaylast">Actions</th>
									</tr>
									<?php $count = 0; foreach($active_list as $app){ ?>
										<tr>
											<td>
												<a href="/applications/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="center">
												<div id="public-modal<?php echo $app->id; ?>" title="Public Key for <?php echo $app->name; ?>">
													<?php echo $app->public_key; ?>
												</div>
												<a href="#" onclick="setTimeout(function(){$('#StatusUpdater').text('<?php echo "Public key for ". $app->name. " is ".implode(' ',str_split($app->public_key)); ?>');},10);"  id="public-link<?php echo $app->id; ?>">View Public Key</a><br/>
												<div id="private-modal<?php echo $app->id; ?>" title="Private Key for <?php echo $app->name; ?>">
													<?php echo $app->private_key; ?>
												</div>
												<a href="#" onclick="setTimeout(function(){$('#StatusUpdater').text('<?php echo "Private key for ". $app->name. " is ".implode(' ',str_split($app->private_key)); ?>');},10);"  id="private-link<?php echo $app->id; ?>">View Private Key</a><br/>
											</td>
											<td>
												<!-- form is actually submitted via ajax and is controlled in main.js -->
												<?PHP echo form_open('/applications/update_key',array('id'=>'keyForm'.$app->id,'class'=>'keyForm')); ?>
													<?PHP echo form_hidden('app_id',$app->id,'app_id'); ?>
													<div class="center">
														<a href="#" onclick="if (confirm('Are you sure you want to regenerate keys for <?php echo $app->name; ?>?')){$('#keyForm<?php echo $app->id; ?>').submit();}" title="Regenerate Keys: <?php echo $app->name; ?>"><img src="/images/icons/key_go.png" alt="Regenerate Keys: <?php echo $app->name; ?>" /></a>
														<a href="/applications/edit/<?php echo $app->id; ?>/<?php if($active_cur_page){echo $active_cur_page;}else{echo 1;} ?>/<?php if($active_items_per_page){echo $active_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>/
														<?php if($pending_cur_page){echo $pending_cur_page;}else{echo 1;} ?>/<?php if($pending_items_per_page){echo $pending_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>/
														<?php if($denied_cur_page){echo $denied_cur_page;}else{echo 1;} ?>/<?php if($denied_items_per_page){echo $denied_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>" title="Edit Application: <?php echo $app->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Application: <?php echo $app->name; ?>" /></a>
													</div>
												<?PHP echo form_close(); ?>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
							<?php } ?>
							<br/>
							<p class="center">
								<input type="button" class="blue-button" onclick="location.href='/onboarding/request/'" value="Request New Application"/>
							</p>
						</div>
						<div id="pending">
							<p>This table lists the applications that are currently waiting for authorization to utilize the Direct API 
							web services.</p>
							
							<?php if (sizeof($pending_list) == 0) { ?>
								<div class="message">You currently have no application requests pending approval.</div>
							<?php }else{ ?>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($pending_size)) { echo $pending_size; } else {echo "0";}?> result<?php if(isset($pending_size) && $pending_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($pending_pagination_bar)) { echo $pending_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($pending_items_per_page_dropdown)) { echo $pending_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="pending_page_select" name="pending_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $pending_items_per_page;?>, 'pending_');" >
												<?php for($count = 1;$count <= $pending_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $pending_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $pending_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
								<table class="display">
									<tr>
										<th width="25%">Name</th>
										<th width="25%">POC</th>
										<th width="25%">Justification</th>
										<th width="25%" class="displaylast">Request Date</th>
									</tr>
									<?php foreach($pending_list as $app){ ?>
										<tr>
											<td>
												<a href="/onboarding/request/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td><?php echo $app->justification; ?>&nbsp;</td>
											<td><?php echo date("M d Y H:i:s",$app->requested_date); ?>&nbsp;</td>
										</tr>
									<?php } ?>
								</table>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($pending_size)) { echo $pending_size; } else {echo "0";}?> result<?php if(isset($pending_size) && $pending_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($pending_pagination_bar)) { echo $pending_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($pending_items_per_page_dropdown)) { echo $pending_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="pending_page_select" name="pending_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $pending_items_per_page;?>, 'pending_');" >
												<?php for($count = 1;$count <= $pending_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $pending_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $pending_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
							<?php } ?>
						</div>
						<div id="denied">
							<p>This table lists the applications that have been rejected access to utilize the Direct API 
							web services. Please update the necessary information and resubmit.</p>
							
							<?php if (sizeof($denied_list) == 0) { ?>
								<div class="message">You currently have no application requests that have been denied.</div>
							<?php }else{ ?>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
								<?PHP echo form_hidden('page_select_correction','','page_select_correction'); ?>
									<div class="pagination">
										<span><?php if(isset($denied_size)) { echo $denied_size; } else {echo "0";}?> result<?php if(isset($denied_size) && $denied_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($denied_pagination_bar)) { echo $denied_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($denied_items_per_page_dropdown)) { echo $denied_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="denied_page_select" name="denied_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $denied_items_per_page;?>, 'denied_');" >
												<?php for($count = 1;$count <= $denied_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $denied_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $denied_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
								<table class="display">
									<tr>
										<th width="20%">Name</th>
										<th width="20%">POC</th>
										<th width="20%">Justification</th>
										<th width="20%">Request Date</th>
										<th width="20%" class="displaylast">Denial Reason</th>
									</tr>
									<?php foreach($denied_list as $app){ ?>
										<tr>
											<td>
												<a href="/onboarding/request/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td><?php echo $app->justification; ?>
											<td><?php echo date("M d Y H:i:s",$app->requested_date); ?>&nbsp;</td>
											<td><?php echo $app->denial_reason; ?>&nbsp;</td>
										</tr>
									<?php } ?>
								</table>
								<?PHP echo form_open('/applications/list',array('id'=>'app_list_form')); ?>
								<div class="pagination">
									<span><?php if(isset($denied_size)) { echo $denied_size; } else {echo "0";}?> result<?php if(isset($denied_size) && $denied_size !== 1) { echo 's'; } ?></span>
									<label class="hidden_context">Page Selecting Buttons</label>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($denied_pagination_bar)) { echo $denied_pagination_bar; }?></span>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($denied_items_per_page_dropdown)) { echo $denied_items_per_page_dropdown; }?></span>
									<div style="float:right; position:relative">
										<label class="hidden_context">Page Selector</label>Page
										<select id="denied_page_select" name="denied_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $denied_items_per_page;?>, 'denied_');" >
											<?php for($count = 1;$count <= $denied_num_pages;$count++){ ?>
											<option value="<?php echo $count;?>" <?php if ($count == $denied_cur_page){echo "selected";}?>><?php echo $count;?></option>
											<?php  } ?>
										</select>
										<span class="text"> of <?php echo $denied_num_pages;?></span>
									</div>
								</div>
								<?PHP echo form_close(); ?>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo json_encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo json_encode($form_values); ?>);
</script>
